from puzzle_logger import log_decorator, window_logger

@window_logger
@log_decorator
def double_value(value, puzzle_logger_path=None, block_text=None, block_id=None, window_log=False, **kwargs):
    if isinstance(value, (int, float)):
        return value * 2
    
    if isinstance(value, str):
        try:
            return float(value) * 2
        except ValueError:
            raise ValueError(f"Некорректный аргумент: '{value}' не является числом")
    
    raise TypeError(f"Тип '{type(value).__name__}' не поддерживается")